!define VERSION "4.0"

; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Atari800Win PLus"
!define PRODUCT_VERSION "4.0"
!define PRODUCT_PUBLISHER "Marcin Lewandowski"
!define PRODUCT_WEB_SITE "http://atariarea.histeria.pl/PLus/index_us.htm"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\Atari800Win.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

!define FULLNAME "${PRODUCT_NAME} ${VERSION}"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON ".\Res\AtariXL.ico"
!define MUI_UNICON ".\Res\AtariXE.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE ".\License.txt"
; Components
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!define MUI_FINISHPAGE_NOAUTOCLOSE
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\Atari800Win.exe"
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\file_id.diz"
!define MUI_FINISHPAGE_LINK "Atari800Win PLus homepage"
!define MUI_FINISHPAGE_LINK_LOCATION "http://atariarea.histeria.pl/PLus/index_us.htm"
!define MUI_FINISHPAGE_NOREBOOTSUPPORT
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Polish"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${FULLNAME}.exe"
InstallDir "$PROGRAMFILES\Atari800WinPLus"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "Atari800Win PLus" SEC01
  SetOutPath "$INSTDIR"
  File ".\Release\Atari800Win.exe"
  CreateDirectory "$SMPROGRAMS\Atari800Win PLus"
  CreateShortCut "$SMPROGRAMS\Atari800Win PLus\${FULLNAME}.lnk" "$INSTDIR\Atari800Win.exe"
  File ".\Help\ATARI800WIN.HLP"
  File ".\Help\ATARI800WIN.CNT"
  CreateShortCut "$SMPROGRAMS\Atari800Win PLus\${FULLNAME} Help.lnk" "$INSTDIR\ATARI800WIN.HLP"
  File ".\Distribution\Atari800Win\file_id.diz"
  File ".\Distribution\Atari800Win\kailleraclient.dll"
  SetOutPath "$INSTDIR\Keyboard"
  File ".\Distribution\Atari800Win\Keyboard\Default.a8k"
  File ".\Distribution\Atari800Win\Keyboard\Raster.a8k"
  File ".\Distribution\Atari800Win\Keyboard\Ultima3.a8k"
  SetOutPath "$INSTDIR\Palette"
  File ".\Distribution\Atari800Win\Palette\Default.act"
  File ".\Distribution\Atari800Win\Palette\Gray.act"
  File ".\Distribution\Atari800Win\Palette\Green.act"
  File ".\Distribution\Atari800Win\Palette\Jakub.act"
  File ".\Distribution\Atari800Win\Palette\Real.act"
  File ".\Distribution\Atari800Win\Palette\Xformer.act"
  SetOutPath "$INSTDIR\Trainer"
  File ".\Distribution\Atari800Win\Trainer\AlleyCat.a8t"
  File ".\Distribution\Atari800Win\Trainer\BlueThunder.a8t"
  File ".\Distribution\Atari800Win\Trainer\BoulderDash.a8t"
  File ".\Distribution\Atari800Win\Trainer\BruceLee.a8t"
  File ".\Distribution\Atari800Win\Trainer\Conan.a8t"
  File ".\Distribution\Atari800Win\Trainer\DanStrikesBack.a8t"
  File ".\Distribution\Atari800Win\Trainer\DonkeyKong.a8t"
  File ".\Distribution\Atari800Win\Trainer\DonkeyKongJunior.a8t"
  File ".\Distribution\Atari800Win\Trainer\Draconus.a8t"
  File ".\Distribution\Atari800Win\Trainer\Dropzone.a8t"
  File ".\Distribution\Atari800Win\Trainer\FortApocalypse.a8t"
  File ".\Distribution\Atari800Win\Trainer\Goonies.a8t"
  File ".\Distribution\Atari800Win\Trainer\Gyruss.a8t"
  File ".\Distribution\Atari800Win\Trainer\HERO.a8t"
  File ".\Distribution\Atari800Win\Trainer\JetSetWilly.a8t"
  File ".\Distribution\Atari800Win\Trainer\KeystoneKapers.a8t"
  File ".\Distribution\Atari800Win\Trainer\Loco.a8t"
  File ".\Distribution\Atari800Win\Trainer\MontezumasRevenge.a8t"
  File ".\Distribution\Atari800Win\Trainer\MoonPatrol.a8t"
  File ".\Distribution\Atari800Win\Trainer\MrRobotAndHisRobotFactory.a8t"
  File ".\Distribution\Atari800Win\Trainer\RiverRaid.a8t"
  File ".\Distribution\Atari800Win\Trainer\Starquake.a8t"
  File ".\Distribution\Atari800Win\Trainer\Zorro.a8t"
  File ".\Distribution\Atari800Win\Trainer\Zorro_FullVersion.a8t"
SectionEnd

Section "Desktop shortcut" SEC02
  SetOutPath "$INSTDIR"
  CreateShortCut "$DESKTOP\${FULLNAME}.lnk" "$INSTDIR\Atari800Win.exe"
SectionEnd

Section "Quicktray shortcut" SEC03
  SetOutPath "$INSTDIR"
  CreateShortCut "$QUICKLAUNCH\${FULLNAME}.lnk" "$INSTDIR\Atari800Win.exe"
SectionEnd

Section -AdditionalIcons
  SetOutPath "$INSTDIR"
  WriteIniStr "$INSTDIR\Atari800Win.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\Atari800Win PLus\Website.lnk" "$INSTDIR\Atari800Win.url"
  CreateShortCut "$SMPROGRAMS\Atari800Win PLus\Uninstall.lnk" "$INSTDIR\Uninstall.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\Uninstall.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\Atari800Win.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\Uninstall.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\Atari800Win.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "Application $(^Name) has been uninstalled."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Do You want to uninstall $(^Name)?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\Atari800Win.url"
  Delete "$INSTDIR\Uninstall.exe"
  Delete "$INSTDIR\Trainer\Zorro_FullVersion.a8t"
  Delete "$INSTDIR\Trainer\Zorro.a8t"
  Delete "$INSTDIR\Trainer\Starquake.a8t"
  Delete "$INSTDIR\Trainer\RiverRaid.a8t"
  Delete "$INSTDIR\Trainer\MrRobotAndHisRobotFactory.a8t"
  Delete "$INSTDIR\Trainer\MoonPatrol.a8t"
  Delete "$INSTDIR\Trainer\MontezumasRevenge.a8t"
  Delete "$INSTDIR\Trainer\Loco.a8t"
  Delete "$INSTDIR\Trainer\KeystoneKapers.a8t"
  Delete "$INSTDIR\Trainer\JetSetWilly.a8t"
  Delete "$INSTDIR\Trainer\HERO.a8t"
  Delete "$INSTDIR\Trainer\Gyruss.a8t"
  Delete "$INSTDIR\Trainer\Goonies.a8t"
  Delete "$INSTDIR\Trainer\FortApocalypse.a8t"
  Delete "$INSTDIR\Trainer\Dropzone.a8t"
  Delete "$INSTDIR\Trainer\Draconus.a8t"
  Delete "$INSTDIR\Trainer\DonkeyKongJunior.a8t"
  Delete "$INSTDIR\Trainer\DonkeyKong.a8t"
  Delete "$INSTDIR\Trainer\DanStrikesBack.a8t"
  Delete "$INSTDIR\Trainer\Conan.a8t"
  Delete "$INSTDIR\Trainer\BruceLee.a8t"
  Delete "$INSTDIR\Trainer\BoulderDash.a8t"
  Delete "$INSTDIR\Trainer\BlueThunder.a8t"
  Delete "$INSTDIR\Trainer\AlleyCat.a8t"
  Delete "$INSTDIR\Palette\Xformer.act"
  Delete "$INSTDIR\Palette\Real.act"
  Delete "$INSTDIR\Palette\Jakub.act"
  Delete "$INSTDIR\Palette\Green.act"
  Delete "$INSTDIR\Palette\Gray.act"
  Delete "$INSTDIR\Palette\Default.act"
  Delete "$INSTDIR\Keyboard\Ultima3.a8k"
  Delete "$INSTDIR\Keyboard\Raster.a8k"
  Delete "$INSTDIR\Keyboard\Default.a8k"
  Delete "$INSTDIR\kailleraclient.dll"
  Delete "$INSTDIR\file_id.diz"
  Delete "$INSTDIR\ATARI800WIN.HLP"
  Delete "$INSTDIR\ATARI800WIN.CNT"
  Delete "$INSTDIR\ATARI800WIN.gid"
  Delete "$INSTDIR\ATARI800WIN.fts"
  Delete "$INSTDIR\Atari800Win.exe"

  Delete "$SMPROGRAMS\Atari800Win PLus\Uninstall.lnk"
  Delete "$SMPROGRAMS\Atari800Win PLus\Website.lnk"
  Delete "$SMPROGRAMS\Atari800Win PLus\${FULLNAME} Help.lnk"
  Delete "$DESKTOP\${FULLNAME}.lnk"
  Delete "$QUICKLAUNCH\${FULLNAME}.lnk"
  Delete "$SMPROGRAMS\Atari800Win PLus\${FULLNAME}.lnk"

  RMDir "$SMPROGRAMS\Atari800Win PLus"
  RMDir "$INSTDIR\Trainer"
  RMDir "$INSTDIR\Palette"
  RMDir "$INSTDIR\Keyboard"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd